class Portal extends Actor
    abstract;

#exec TEXTURE IMPORT NAME="BluePortal" FILE="C:\DeusEx\MSInventions1_3\Textures\BluePortal.pcx" GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME="YellowPortal" FILE="C:\DeusEx\MSInventions1_3\Textures\YellowPortal.pcx" GROUP=Skins FLAGS=2
#exec AUDIO IMPORT FILE="C:\DeusEx\MSInventions1_3\Sounds\PortalMove.wav"  NAME="PortalMove"  GROUP="Portal"
#exec AUDIO IMPORT FILE="C:\DeusEx\MSInventions1_3\Sounds\PortalOpen.wav"  NAME="PortalOpen"  GROUP="Portal"

var () Float ExplosionRadius;

function Explode(vector HitLocation)
{
	local int i;
	local DeusExFragment s;
	local ExplosionLight light;

//	PlaySound(explosionSound, SLOT_None, 2.0,, 2048);

//	AISendEvent('LoudNoise', EAITYPE_Audio, , ExplosionRadius*16);

	light = Spawn(class'ExplosionLight',,, HitLocation);
	if ( light != None )
		light.size = 4;

	Spawn(class'ExplosionSmall',,, Location);
	
	for (i=0; i<5; i++)
	{
		s = Spawn(class'RockChip', Owner);
		if (s != None)
		{
			s.Instigator = Instigator;
			s.CalcVelocity(Velocity, ExplosionRadius);
			s.DrawScale = 0.5;
			s.Skin = GetMeshTexture();
			if (FRand() < 0.75)
				s.bSmoking = True;
		}
	}

	HurtRadius(250, ExplosionRadius, 'Exploded', 100*ExplosionRadius, Location);
        Destroy();
}

function PostBeginPlay()
{
        PlaySound(sound'PortalOpen', SLOT_None);
	Super.PostBeginPlay();
}

defaultproperties
{
     explosionRadius=160.000000
}
